import vibe.vibe;
import vibe.db.mongo.mongo;
import std.datetime.systime : SysTime, Clock;
import anahtar.teklianahtar;

struct Kullanıcı
{
    @name("_id") int no;
    string isim;
    string eposta;
    string kullanıcı;
    ubyte[32] şifre;
    string çeşni;
    SysTime oluşturmazamanı;
}

int sonrakiKaydaGeç(string isim)
{
    auto veritabanı = connectMongoDB("127.0.0.1").getDatabase("kiraz");
    auto sayaç = veritabanı["sayaç"];
    auto sonuç = sayaç.findAndModifyExt(["_id": isim], ["$inc": ["değer": 1]], ["new": true]);
    logInfo("Sonuç %s", sonuç);
    return sonuç["değer"].get!int;
}

void kullanıcıOluştur (HTTPServerRequest istek, HTTPServerResponse yanıt)
{
    import std.array:empty;

    string isim = istek.form.get("isim");
    string ePosta = istek.form.get("eposta");
    string kullanıcıİsmi = istek.form.get("kullaniciismi");
    string şifre = istek.form.get("sifre");
    string şifreTekrar = istek.form.get("sifretekrar");

    logInfo("Alınan bilgiler İsim = %s Eposta = %s", isim, ePosta);

    if (isim.empty || ePosta.empty || şifre.empty || şifre != şifreTekrar)
        yanıt.redirect("/kayıtol");
    else
    {
        auto veritabanı = connectMongoDB("127.0.0.1").getDatabase("kiraz");
        auto kullanıcılar = veritabanı["kullanıcılar"];

        Kullanıcı yeniKullanıcı;
        yeniKullanıcı.no = sonrakiKaydaGeç("kullanıcıno");
        yeniKullanıcı.isim = isim;
        yeniKullanıcı.eposta = ePosta;
        yeniKullanıcı.kullanıcı = kullanıcıİsmi;
        auto çeşni = çeşniÜret();
        auto anahtar = tekliAnahtarÜret(şifre, çeşni);
        yeniKullanıcı.şifre = anahtar;
        yeniKullanıcı.çeşni = çeşni;
        yeniKullanıcı.oluşturmazamanı = Clock.currTime();
        assert(anahtarıDoğrula(anahtar, şifre, çeşni));
        kullanıcılar.insertOne(yeniKullanıcı);
        yanıt.redirect("/");
    }
}

void main()
{
    auto yolAtayıcı = new URLRouter;
    yolAtayıcı.get("/", staticTemplate!"gunluk/index.dt");
    yolAtayıcı.get("/kayıtol", staticTemplate!"kullanici/olustur.dt");
    yolAtayıcı.post("/kullanıcı/oluştur", &kullanıcıOluştur);
    yolAtayıcı.get("*", serveStaticFiles("public"));
    auto ayarlar = new HTTPServerSettings;
    ayarlar.port = 8080;
    ayarlar.bindAddresses = ["::1", "127.0.0.1"];
    listenHTTP(ayarlar, yolAtayıcı);

    logInfo("Lütfen tarayıcınızla http://127.0.0.1:8080/ adresini açınız.");
    runApplication();
}
