module anahtar.teklianahtar;

string çeşniÜret(uint uzunluk = 32) @safe
{
    import std.process;
    import std.stdio;
    import std.conv;
    import std.random, std.array, std.range;

    version (Posix)
    {
        string kaçTane = to!string(uzunluk);
        auto komut = "LC_ALL=C tr -dc '[:alnum:]' < /dev/urandom | head -c" ~ kaçTane;
        auto rastgele = executeShell(komut);
        if (rastgele.status != 0)
            writeln("Rastgele dizge üretilmesi başarısız oldu");
        else
        {
            return rastgele.output;
        }
    }
    else version (Windows)
    {
        dchar[] alfabe = "abcçdefgğhıijklmnoöprsştuüvyzABCÇDEFGĞHIİJKLMNOÖÖPRSŞTUÜVYZ"d.dup;
        alfabe ~= "0123456789~!@#$%^&*()-+=?/<>|[]{}_:;.,`"d.dup;
        dchar[] sonuç = array(take(randomCover(alfabe, rndGen), uzunluk));
        return to!string(sonuç);
    }
    assert(0);
}

bool anahtarıDoğrula(ubyte[32] anahtar, string şifre, string çeşni)
{
    import std.digest.sha;
    auto geçiciAnahtar = makeDigest!SHA256();
    geçiciAnahtar.put(cast(ubyte[])şifre);
    geçiciAnahtar.put(cast(ubyte[])çeşni);
    auto sonuç = geçiciAnahtar.finish();
    return anahtar == sonuç;
}

ubyte[32] tekliAnahtarÜret(string şifre, string çeşni)
{
    import std.digest.sha;
    auto anahtar = makeDigest!SHA256();
    anahtar.put(cast(ubyte[])şifre);
    anahtar.put(cast(ubyte[])çeşni);
    auto sonuç = anahtar.finish();
    return sonuç;
}

unittest
{
    import std.stdio;
    import std.digest : toHexString;

    auto çeşni = çeşniÜret();
    writeln("Çeşni = ", çeşni);
    auto şifre = "abc";
    auto anahtar = tekliAnahtarÜret(şifre, çeşni);
    writeln("Anahtar = ", anahtar.toHexString());
    assert(anahtarıDoğrula(anahtar, şifre, çeşni));
    assert(!anahtarıDoğrula(anahtar, "ab", çeşni));
    auto farklıÇeşni = çeşniÜret();
    assert(!anahtarıDoğrula(anahtar, şifre, farklıÇeşni));
}

